! State initial values

n_step = 1500
x_min = -7.500
y_min = -7.500
x_max = 7.500
y_max = 7.500
x_step = (x_max-x_min)/n_step
y_step = (y_max-y_min)/n_step
n_step = n_step+1
nx_step = n_step+1
filename$ = "\LightForge_gridXYZ.dat"

! Specify output format and path

FORMAT .3
INPUT "Directory to save LightForge_gridXYZ.dat file:", design_folder$
filepath$ = design_folder$ + filename$
OUTPUT filepath$

! Create x and y vectors and print x vector

DECLARE x_vec, DOUBLE, 1, nx_step
DECLARE y_vec, DOUBLE, 1, n_step
FOR n, 1, nx_step, 1
	if (n == 1) 
		x_vec(n) = 0
	else
		x_vec(n) = (x_min + x_step*(n-2))*1000
	endif
	PRINT x_vec(n),"	",
	if (n == nx_step) THEN PRINT
NEXT n

FOR n, 1, n_step, 1
	y_vec(n) = (y_min + y_step*(n-1))*1000
NEXT n

! Print process description text
	
FORMAT 1.0
OUTPUT SCREEN
PRINT "Sampling the z-surface with ", x_step*1000, "x", y_step*1000, " micrometre grid..."
OUTPUT filepath$, APPEND
FORMAT .3

! Create source ray for sampling z-array

INSERTOBJECT 1, 1
SETNSCPROPERTY 1, 1, 0, 0, NSC_SRAY
SETNSCPARAMETER 1, 1, 2, 1

! Calculate z at x and y, add y vector

FOR ny, 1, n_step, 1
	y_val = y_min + (y_step*(ny-1))
	PRINT y_vec(ny),"	",
	
	! Print process output text

	OUTPUT SCREEN
	perc2comp = inte(100*ny/n_step)
	FORMAT 1.0
	PRINT  perc2comp,"% complete"
	FORMAT .3
	OUTPUT filepath$, APPEND

	FOR nx, 1, n_step, 1
		x_val = x_min + (x_step*(nx-1))
		SETNSCPOSITION 1, 1, 1, x_val
		SETNSCPOSITION 1, 1, 2, y_val
		UPDATE
		C = OCOD("NSRA")
		E = OPEV(C, 1, 1, 0, 0, 1, 3)
		PRINT -E*1000,"	",
		if (nx == n_step) & (ny < n_step) THEN PRINT
	NEXT nx
NEXT ny

! Convert file to ANSI and end program

DELETEOBJECT 1,1
OUTPUT SCREEN
PRINT "Converting file to ANSI format..."
CONVERTFILEFORMAT filepath$, 1
PRINT "GridXYZ save file completed!"

END